// keyselect.c

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "main.h"
#include "players.h"
#include "keyselect.h"
#include "register.h"
#include "keyboard.h"
#include "gameticks.h"
#include "midi.h"
#include "random.h"


void InitInputSprocket( void )
{
}

void StopInputSprocket( void )
{
}

unsigned char CheckKeys( Boolean allowCmdKeys, void (*ShutdownFunc)(void), void (*RestartFunc)(void) )
{
	short player, array;
	KeyMap keys;
	const UInt32 state = 0;
	EventRecord e;
	unsigned char pressedKey = 0;
	
	// YieldToBackgroundTasks();
	
	if( allowCmdKeys )
	{
		WaitNextEvent( everyEvent, &e, 0, nil );
		if( (e.what == keyDown) || (e.what == autoKey) )
		{
			pressedKey = e.message & charCodeMask;

			if( e.modifiers & cmdKey )
			{
				// Command-Q
				if( toupper(pressedKey) == 'Q' )
				{
					finished = true;
					return 0;
				}

				// Command-Tab
				if( pressedKey == '\t' )
				{
					if( ShutdownFunc ) ShutdownFunc();
					GoToBackground( true, true );
					if( RestartFunc ) RestartFunc();
					return 0;
				}
			}
		}
		else if( e.what == updateEvt )
		{
			BeginUpdate      ( (WindowPtr) e.message );
			SetPortWindowPort( (WindowPtr) e.message );
			EndUpdate        ( (WindowPtr) e.message );
		}
	}

	GetKeys( keys );
		
	// Check for game keys
	for( player=0, array=0; player<=1; player++, array+=4 )
	{
		
		if( state || KeyIsPressed( keys, keyCode[array + kKey1PLeft] ) )
			hitKey[player].left++; 
		else
			hitKey[player].left = 0;


		if( state || KeyIsPressed( keys, keyCode[array + kKey1PRight] ) )		
			hitKey[player].right++; 
		else
			hitKey[player].right = 0;


		if( state || KeyIsPressed( keys, keyCode[array + kKey1PDrop] ) ) 			
			hitKey[player].drop++; 
		else
			hitKey[player].drop = 0;


		if( state || KeyIsPressed( keys, keyCode[array + kKey1PRotate] ) )
			hitKey[player].rotate++; 
		else
			hitKey[player].rotate = 0;
	}
	
	pauseKey = state || KeyIsPressed( keys, keyCode[kKeyPause] );
	
	return pressedKey;
}

void ConfigureInputSprocket( void )
{
}
